import subprocess
#import pandas as pd
import argparse
import sys
import os

#import viewdat_cno_lib as vdl

parser = argparse.ArgumentParser(
    description='Apply an elevation mask with t0x2t0x.',
    formatter_class=argparse.ArgumentDefaultsHelpFormatter,
)
parser.add_argument(
    '-F', "--folder",
    default='240918',
    help="Base folder name."
)
parser.add_argument(
    '-e', '--elev',
    type=int,
    default=10,
    help="Elevation Mask to apply."
)
parser.add_argument(
    '--t04_list',
    nargs='+', 
    default=['BX992_all.T04', 'EB1-5093_all.T04', 'EB1-5095_all.T04',
             'EB-5081_all.T04', 'P4-05_all.T04'],
    help="Elevation Mask to apply."
)
parser.add_argument(
    "-n", "--dry_run",
    action='store_true',
    help="Don't actually run t0x2t0x, just print the commands."
)
args = parser.parse_args()

el_dir = f'{args.folder}_el{args.elev}'
os.makedirs(el_dir, exist_ok=True)
for t in args.t04_list:
    t04_path = os.path.join(args.folder, t)
    t04_path_el = os.path.join(el_dir, t)
    cmd = ['t0x2t0x', f'-elev={args.elev}', t04_path, t04_path_el]
    print(' '.join(cmd))
    log_fname = f'prep_elev_el{args.elev}_{t[:-4]}.log'
    print(f'{log_fname=}')

    if args.dry_run:
        continue
    f = open(log_fname, 'w')
    p = subprocess.run(cmd,
                       stderr=subprocess.STDOUT, stdout=f,
                       #capture_output = True, # Python >= 3.7 only
                       #text = True # Python >= 3.7 only
    )
    f.close()
    if p.returncode != 0:
        print(f'*** WARNING *** viewdat return code {p.returncode}')

