#!/usr/bin/python3

import os
import subprocess

devs = ['BX992', 'EB1-5093',  'EB1-5095',  'EB-5081',  'P4-05']

indir = '240918'
for ant in [0, 1]:
    outdir = f'{indir}_ant{ant}'
    os.makedirs(outdir, exist_ok=True)
    for dev in devs:
        log_fname = os.path.join(outdir, f'prep_ant_t0x_{dev}_ant{ant}.log')
        print(f'{log_fname=}')

        cmd = ['t0x2t0x', f'-a={ant}',
               f'{indir}/{dev}_all.T04',
               f'{outdir}/{dev}.T04',
               ]
        print(' '.join(cmd))

        f = open(log_fname, 'w')
        p = subprocess.run(cmd,
                           stderr=subprocess.STDOUT, stdout=f,
                           #capture_output = True, # Python >= 3.7 only
                           #text = True # Python >= 3.7 only
        )
        f.close()
        if p.returncode != 0:
            print(f'*** WARNING *** viewdat return code {p.returncode}')
