import os
import subprocess
import time
import pandas as pd

folder = '.'
records = []
with os.scandir(folder) as it:
    for entry in it:
        d = entry.name
        if not entry.is_dir() or d.startswith('_') or d.startswith('.'):
            continue
        for dut in ['P4-03', 'P4-05']:
           f = os.path.join(folder, d,
                               'gen_data', 'position', dut,
                               #'pos_ant.csv'
                               f'{dut}_ant0_local.feather'
                               )
           if not os.path.isfile(f):
               print(f'{f} not found')
               continue
           print(f"============ {f} =====================")
           #df = pd.read_csv(f)
           df = pd.read_feather(f)
           a0_h_mean = df.MHgt.mean()
           a1_h_mean = df.VHgt.mean()
           records.append({
                           'folder': d,
                           'dut': dut,
                           'a0_h_mean': a0_h_mean,
                           'a1_h_mean': a1_h_mean,
                           })

df = pd.DataFrame(records)
df = df.sort_values('folder')
print(df)
df.to_csv('titan_vdiff.csv', index=False)


