# Urban Canyon Post Processing Command History

These are roughly the commands/scripts that have been used. as run from the
Urban Canyon directory.

proces the raw T04

    all_pos --dut_dirs P4-03-all P4-05-all --force_calc --parallel

process as NOT VSBL

    # This one may not be needed
    proc_titan --ini no-vsbl-static.ini --hud_dir titan --dut_dirs P4-03 P4-05

Process Ant 0 and Ant1 independendtly:

    python3 urban_t0x_ant.py -a 0
    python3 urban_t0x_ant.py -a 1
    proc_titan --ini ant1.ini --in_dir gen_data/ant1 --hud_dir titan-ant1-survey-base --rtk_dir survey-base --dut_dirs P4-03 P4-05
    proc_titan --ini ant1.ini --in_dir gen_data/ant0 --hud_dir titan-ant0-survey-base --rtk_dir survey-base --dut_dirs P4-03 P4-05
    all_pos --dut_dirs P4-03 P4-05 --hud --hud_dir titan-ant1-survey-base
    all_pos --dut_dirs P4-03 P4-05 --hud --hud_dir titan-ant0-survey-base
    #all_pos --dut_dirs P4-03 P4-05 --hud --hud_dir titan --force --parallel

Process as VSBL, with hourly T04 files (Didn't work):

    proc_titan --ini vsbl-static.ini --hud_dir titan-vsbl --rtk_dir survey-base --dut_dirs P4-03 P4-05
    all_pos --dut_dirs P4-03 P4-05 --hud --hud_dir titan-vsbl --force --parallel

Some bases (WCO-Base) had T02 files, which don't work with TitanPlayer:

    # Convert T02 to T04, from within a directory (like 240111/data/gnss/WCO-Base/)
    for f in *.T02; do s="${f##*/}"; t0x2t0x --translate_rec27_to_rec35_sub19 "$s" "${s%.*}.T04"; done
    # OR from this directory (CSNMR-2877_VSBL_Urban_Canyon) do:
    python3 t02_t04_dir.py -d 240122

    # For all days:
    python3 t02_t04_dir.py -D WCO-Base-all --parallel
    all_pos --dut_dirs P4-03-all P4-05-all --hud --hud_dir titan-WCOB-vsbl --force --parallel

Process as VSBL, with a daily T04 file:

    python3 combine_hourly.py
    proc_titan --ini vsbl-survey-base.ini --hud_dir titan-vsbl --rtk_dir survey-base-all --dut_dirs P4-03-all P4-05-all
    all_pos --dut_dirs P4-03-all P4-05-all --hud --hud_dir titan-vsbl --force --parallel

    # For WCO Base
    # Assume combine_hourly.py has be run
    # 1st, run t02_t04_dir.py as above
    proc_titan --ini vsbl-survey-base.ini --hud_dir titan-WCOB-vsbl --rtk_dir WCO-Base-all --dut_dirs P4-03-all P4-05-all

Fitler the VSBL results by Sigma/Precision

    # Do combine_hourly and proc_titan steps above (ie re-use the data from these steps)
    all_pos_filter --data_type_dir titan-vsbl --out_folder titan-vsbl-filtered --dut_dirs P4-03-all P4-05-all --ignore_prec_limit 0.08
    all_pos --dut_dirs P4-03-all P4-05-all --data_type_dir titan-vsbl-filtered --force_calc --parallel

    # For WCO-Base
    all_pos_filter --data_type_dir titan-WCOB-vsbl --out_folder titan-WCOB-vsbl-filtered --dut_dirs P4-03-all P4-05-all --ignore_prec_limit 0.08
    all_pos --dut_dirs P4-03-all P4-05-all --data_type_dir titan-WCOB-vsbl-filtered --force_calc --parallel

# Repositories

`proc_titan` and other scripts are from the [montera](https://bitbucket.trimble.tools/projects/OLMP/repos/montera/browse)


<!-- vim: set tw=0: -->
